/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class PanelBlockItem
extends BlockItem {
    private final PanelBlock panelBlock;

    public PanelBlockItem(PanelBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.panelBlock = blockIn;
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.panelBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return new TranslatableComponent("domum_ornamentum.panel.name.format", new Object[]{centerBlockName});
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TrapdoorType trapdoorType;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        try {
            trapdoorType = stack.m_41784_().m_128441_("type") ? TrapdoorType.valueOf(stack.m_41784_().m_128461_("type").toUpperCase()) : TrapdoorType.FULL;
        }
        catch (Exception ex) {
            trapdoorType = TrapdoorType.FULL;
        }
        tooltip.add((Component)new TranslatableComponent("domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("domum_ornamentum.trapdoor.type.format", new Object[]{new TranslatableComponent("domum_ornamentum.trapdoor.type.name." + trapdoorType.getTranslationKeySuffix())}));
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent trapDoorComponent = (IMateriallyTexturedBlockComponent)this.panelBlock.getComponents().get(0);
        Block trapDoorBlock = textureData.getTexturedComponents().getOrDefault(trapDoorComponent.getId(), trapDoorComponent.getDefault());
        Component trapDoorBlockName = BlockUtils.getHoverName(trapDoorBlock);
        tooltip.add((Component)new TranslatableComponent("domum_ornamentum.trapdoor.block.format", new Object[]{trapDoorBlockName}));
    }
}

